function  C = charPathLength(obj,varargin)
%CHARPATHLENGTH Calculate characteristic path length for AdjacencyMatrix
%object
%   C = CHARPATHLENGTH(obj,... 'ParameterName','ParameterValue',...) will
%   calculate the characteristic path length for AdjacencyMatrix obj.  The
%   optional parameters are:
%       'threshold' - Integer determing the threshold value for converting
%       the weighted graph into a binary graph.  The default value is 5.


tolerance = 5;
pTest = false;
for i = 1:length(varargin)
    switch varargin{i}
        case 'threshold'
            tolerance = varargin{i+1};
        case 'pTest'
            pTest = true;
    end
end
[A labels] = getSquareMatrix(obj);


A = double(A>=tolerance);

D = createDistanceMat(A);

dists = D(D<Inf);
C = mean(dists);
diameter = max(dists);

[I J] = ind2sub(size(D),find(D==diameter));

fprintf('Characteristic path length: %.3f\nDiameter: %u\n',C,diameter);
fprintf('Neurons with min path length of %u:\n',diameter);
for i = 1:numel(I)
    fprintf('\t%s to %s\n',labels{I(i)}, labels{J(i)});
end

nIters = 100;
Crand = zeros(1,nIters);
if pTest
    for jj = 1:nIters
        randA = randmio_dir(A,20);
        D = createDistanceMat(A);
        dists = D(D<Inf);
        
        Crand(i) = mean(dists);
    end
    Crand = Crand(Crand>0);
    fprintf('Average characteristic path length for randomly rewired networks: %.3f',mean(Crand));
end



    function D = createDistanceMat(A)
        % Create distance matrix, Dijkstra's algorithm
        D = Inf(size(A));
        D(logical(eye(size(D,1)))) = 0;
        for ii = 1:size(A,1)
            visited = logical(zeros(1,size(A,2)));
            currNode = ii;
            %     fprintf('Current starting point: %u\n',ii);
            %     input('');
            
            while true
                %         fprintf('Visited nodes:');
                %         tmp = find(visited);
                %         if ~isempty(tmp), fprintf(' %u ',tmp(:)); end
                %         fprintf('\nCurrent node: %u\n',currNode);
                nghbrs = find(A(currNode,:));
                %         fprintf('Neighbors:');
                %         fprintf(' %u ',nghbrs(:));
                %         input('');
                
                D(ii,nghbrs) = min(D(ii,nghbrs),D(ii,currNode)+A(currNode,nghbrs));
                visited(currNode) = true;
                if isempty(find(~visited)), break; end
                
                [minDist idx] = min(D(ii,~visited));
                tmp = find(~visited);
                currNode = tmp(idx);
            end
        end
    end

end

        
